﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class ContactUsBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ContactUs GetItem(Guid ContactMessageID, string keyword)
        {
            return ContactUsDB.GetItem(ContactMessageID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<ContactUs> GetList(Guid ContactMessageID, string keyword)
        {
            return ContactUsDB.GetList(ContactMessageID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid ContactMessageID, string keyword)
        {
            return ContactUsDB.GetDataTable(ContactMessageID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid ContactMessageID, string keyword)
        {
            return ContactUsDB.GetDataSet(ContactMessageID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(ContactUs myContactMessage)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                ContactUsDB.Save(myContactMessage);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
